<?php $__env->startSection('conteudo'); ?>


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Funcionários</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Motoristas</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            <?php if($errors->any()): ?>
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li> <?php echo e($erro); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        <?php endif; ?>

            <?php if(session()->has('sms')): ?>
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    <?php echo e(session()->get('sms')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Foto</th>
                                    <th>Nome</th>
                                    <th>BI</th>
                                    <th>Gênero</th>

                                    <th>Função</th>
                                    <th>Telefone</th>
                                    <th>Cidade</th>

                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $funcionario; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $func): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td class="text-center">
                                            <?php if($func->foto == null): ?>
                                                <?php if($func->genero== "M" ): ?>
                                                    <img src="<?php echo e(asset('assets/images/avatar_homem.png')); ?>"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/images/avatar_mulher.jpg')); ?>"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                <?php endif; ?>
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/imagem_funcionario/'.$func->foto)); ?>"
                                                alt="avatar"
                                                style="width: 40px; height: 40px;border-radius: 16px">
                                            <?php endif; ?>
                                        </td>
                                        <td> <?php echo e($func->nome_completo); ?> </td>
                                        <td><?php echo e($func->bi_cedula); ?> </td>
                                        <td>
                                            <?php if( $func->genero== "M" ): ?>
                                                Masculino
                                            <?php else: ?>
                                                Feminino
                                            <?php endif; ?>

                                        </td>

                                        <td><?php echo e($func->funcao); ?> </td>
                                        <td><?php echo e($func->telefone); ?> </td>
                                        <td><?php echo e($func->cidade); ?> </td>

                                        <td>

                                            <a href="" data-toggle="modal" data-target="#ver_director"
                                            onclick="ver_detalhes(<?php echo e(json_encode($func->nome_completo)); ?>, <?php echo e(json_encode($func->bi_cedula)); ?>, <?php echo e(json_encode($func->genero)); ?>, <?php echo e(json_encode($func->funcao)); ?>, <?php echo e(json_encode($func->telefone)); ?>, <?php echo e(json_encode($func->endereco)); ?>, <?php echo e(json_encode($func->data_nascimento)); ?>, <?php echo e(json_encode($func->data_admissao)); ?>, <?php echo e(json_encode($func->cidade)); ?>)">
                                            <i class="fa-solid fa-eye" style="color: rgb(113, 172, 113);"></i>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar_funcionario')): ?>
                                                <a href="" data-toggle="modal" data-target="#editar_director"

                                                onclick="editar_director(<?php echo e(json_encode($func->id)); ?>,<?php echo e(json_encode($func->nome_completo)); ?>, <?php echo e(json_encode($func->bi_cedula)); ?>, <?php echo e(json_encode($func->genero)); ?>, <?php echo e(json_encode($func->funcao)); ?>, <?php echo e(json_encode($func->telefone)); ?>, <?php echo e(json_encode($func->endereco)); ?>,  <?php echo e(json_encode($func->data_nascimento)); ?>, <?php echo e(json_encode($func->data_admissao)); ?>, <?php echo e(json_encode($func->cidade)); ?>)"
                                                >
                                                    <i class="fa-solid fa-pen-to-square" style="color: blue;"></i>
                                                </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar_funcionario')): ?>
                                                <a href="" onclick="retornaid_nome(<?php echo e($func->id); ?>, '<?php echo e($func->nome_completo); ?>')"  data-toggle="modal" data-target="#Eliminar_director">
                                                    <i class="fa-solid fa-trash" style="color: red;"></i>
                                                </a>

                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- [ Main Content ] end -->
</div>





<!-- eliminar director -->
<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Funcionário</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar este Funcionário <label class="badge badge-light-warning" id="dir_nome"></label> ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="<?php echo e(route('eliminar.funcionario')); ?>" method="post" enctype="multipart/form-data" >
                    <?php echo csrf_field(); ?>
                    <input type="text" id="id_director" name="id_director" hidden>
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<!-- editar director -->

<div id="editar_director" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados do Funcionário</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Preencha todos os campos nos dados do Utilizador.

                </div>
                <div  id="sms_erro2" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   As senhas não conicidem.

                </div>
                <div  id="sms_erro3" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Número de BI inválido.

                </div>
                <div  id="sms_erro4" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Número de Telefone inválido.

                </div>
                <div class="modal-body">
                    <form id="formulario_editar" action="<?php echo e(route('editar.funcionario')); ?>" method="post" enctype="multipart/form-data" >
                       <?php echo csrf_field(); ?>
                        <h6 style="color:black">Dados Pessoais</h6>
                        <hr>
                        <div class="row ">
                            <div class="col-md-6">
                                <input type="text" id="id_editar" name="id_editar" hidden>
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Nome:</label>
                                    <input type="text" id="nome_e" name="nome_e" class="form-control" >
                                </div>
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">BI:</label>
                                    <input type="text" id="bi_e" name="bi_e" class="form-control" >
                                </div>

                            </div>
                            <div class="col-md-6 ">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Género:</label>

                                    <select id="genero_e" name="genero_e"  class="form-control">
                                        <option value="">seleccione o gênero</option>
                                        <option value="M">Masculino</option>
                                        <option value="F">Feminino</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Data de Nascimento:</label>
                                    <input type="date" max="<?php echo e(date('Y-m-d')); ?>" id="data_nascimento_e" name="data_nascimento_e" class="form-control">
                                    <small id="data_nascimento_e_erro" style="color: red; display: none;"></small>

                                </div>
                            </div>

                        </div>
                        <h6 style="color:black">Contacto</h6>
                        <hr>
                        <div class="row ">

                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Telefone:</label>
                                <input type="text" id="telefone_e" name="telefone_e" class="form-control">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Cidade:</label>
                                <input type="text" id="cidade_e" name="cidade_e" class="form-control">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Endereço:</label>
                                <input type="text" id="endereco_e" name="endereco_e" class="form-control">
                            </div>

                        </div>
                        <h6 style="color:black">Dados Profissionais</h6>
                        <hr>
                        <div class="row ">

                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Data de Admissão:</label>
                                <input type="date" max="<?php echo e(date('Y-m-d')); ?>" id="data_admissao_e" name="data_admissao_e" class="form-control">
                                <small id="data_admissao_e_erro" style="color: red; display: none;"></small>

                            </div>

                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Função:</label>

                                <select id="funcao_e" name="funcao_e" class="form-control" onchange="activarDivDadosUtilizador()">
                                    <option value="">Seleccione a função</option>
                                    <option  value="Secretaria" >Secretaria</option>
                                    <option value="Vigilante" >Vigilante</option>
                                    <option value="Motorista" >Motorista</option>
                                </select>


                            </div>

                        </div>
                        <div id="utilizador">
                            <hr>
                            <h6 style="color: black">Dados de Utilizador</h6>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Nome de Utilizador <span style="color: red">*</span></label>
                                    <input type="text" id="nome_utilizador" name="nome_utilizador" class="form-control" >
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Email <span style="color: red">*</span></label>
                                    <input type="text" id="email" name="email" class="form-control">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Palavra Passe <span style="color: red">*</span></label>
                                    <input type="text" id="palavra_passe" name="palavra_passe" class="form-control">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Confirmar Palavra Passe <span style="color: red">*</span></label>
                                    <input type="text" id="palavra_passe2" name="palavra_passe2" class="form-control" >
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>


<!-- ver director -->

<div id="ver_director" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Detalhes do Funcionário</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">

               <div class="row ">
                    <div class="col-md-6 ">
                        <h6 style="color:black">Dados Pessoais</h6>
                        <hr>

                        <label for="">Nome: <label id="nome" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">BI: <label id="bi" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Genero: <label id="genero" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Data de Nascimento: <label id="data_nascimento" style="color: rgb(65, 170, 109)" ></label></label>

                    </div>
                    <div class="col-md-6 ">
                        <h6  style="color:black">Contactos</h6>
                        <hr>
                        <label for="">Telefone: <label id="telefone" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Cidade: <label id="cidade" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Endereço: <label id="endereco" style="color: rgb(65, 170, 109)" ></label></label>
                    </div>
                    <div class="col-md-12">
                        <br><br>
                        <h6 style="color:black">Informações Profissionais</h6>
                        <hr>
                        <label for="">Função: <label id="funcao" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Data de Admissão: <label id="data_admissao" style="color: rgb(65, 170, 109)" ></label></label>
                    </div>
               </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('utilizador').style.display = 'none';
    document.getElementById('sms_erro').style.display = 'none';
    document.getElementById('sms_erro2').style.display = 'none';
    document.getElementById('sms_erro3').style.display = 'none';
    document.getElementById('sms_erro4').style.display = 'none';
    var funcao_inical ="";

    function activarDivDadosUtilizador(){
        var valor = document.getElementById('funcao_e').value;

        if(valor ==='Secretaria' && funcao_inical != 'Secretaria'){
            document.getElementById('utilizador').style.display = 'block';
        }else{
            document.getElementById('utilizador').style.display = 'none';
        }
    }

    function retornaid_nome(id,nome){
        $('#id_director').val(id);
        document.getElementById("dir_nome").innerHTML = nome;
    }

    function ver_detalhes(nome_completo, bi_cedula, genero, funcao, telefone , endereco , data_nascimento, data_admissao, cidade){

            document.getElementById("nome").innerHTML = nome_completo;
            document.getElementById("bi").innerHTML = bi_cedula ;
            if(genero==="M"){
                document.getElementById("genero").innerHTML = 'Masculino';
            }else{
                document.getElementById("genero").innerHTML = 'Feminino';
            }
            document.getElementById("funcao").innerHTML = funcao ;
            document.getElementById("telefone").innerHTML = telefone;
            document.getElementById("endereco").innerHTML = endereco;
            document.getElementById("data_nascimento").innerHTML = data_nascimento;
            document.getElementById("data_admissao").innerHTML = data_admissao;
            document.getElementById("cidade").innerHTML = cidade ;
    }

    function editar_director(id, nome_completo, bi_cedula, genero, funcao, telefone , endereco , data_nascimento, data_admissao, cidade){
        funcao_inical = funcao;



        document.getElementById("id_editar").value = id;
        document.getElementById("nome_e").value = nome_completo;
        document.getElementById("bi_e").value = bi_cedula ;
        document.getElementById("genero_e").value = genero;
        document.getElementById("funcao_e").value = funcao ;
        document.getElementById("telefone_e").value = telefone;
        document.getElementById("endereco_e").value = endereco;
        document.getElementById("data_nascimento_e").value = data_nascimento;
        document.getElementById("data_admissao_e").value = data_admissao;
        document.getElementById("cidade_e").value = cidade ;
    }

    function verificarBI(bi) {

        const padrao = /^[0-9]{9}(BO|BA|BE|CA|CC|KN|KS|CE|HO|HA|LA|LN|LS|ME|MO|NA|UE|ZA)[0-9]{3}$/;
        bi = bi.toUpperCase();

        if (bi != "" && bi.length === 14) {
            if (padrao.test(bi)) {

                return true;
            }

        }

        return false;
    }

    function verificarTelefone(telefone) {

        const padrao = /^(9)[0-9]{8}$/;

        if (telefone !="" && padrao.test(telefone)) {

            return true;
        }

        return false;
    }

    function verificarsenha(s1, s2) {
        if (s1 === s2 && s1 !='') {

             return true;
        }
        return false;
    }

    function verificarRegisto(){
        event.preventDefault();

        var funcao = document.getElementById('funcao_e').value;
        var bi = document.getElementById('bi_e').value;
        var telefone = document.getElementById('telefone_e').value;
        var nome_uti = document.getElementById('nome_utilizador').value;
        var email = document.getElementById('email').value;
        var senha1 = document.getElementById('palavra_passe').value;
        var senha2 = document.getElementById('palavra_passe2').value;

        if(funcao === "Secretaria" && funcao_inical != "Secretaria"){
            if(nome_uti ==='' || email ==='' || senha1 ==='' || senha2 ==='' ){
                document.getElementById('sms_erro').style.display = 'block';
            }else if(verificarsenha(senha1, senha2)=== false ){

                document.getElementById('sms_erro2').style.display = 'block';
            }else{
                document.getElementById('sms_erro2').style.display = 'none';

                if(verificarBI(bi) === false){

                    document.getElementById('sms_erro3').style.display = 'block';
                }else{

                    document.getElementById('sms_erro3').style.display = 'none';
                }

                if(verificarTelefone(telefone)=== false){
                    document.getElementById('sms_erro4').style.display = 'block';
                }else{
                    document.getElementById('sms_erro4').style.display = 'none';
                }

                if(verificarBI(bi)===true && verificarTelefone(telefone)===true){
                    document.getElementById('formulario_editar').submit();
                }
            }
        }else{

            if(verificarBI(bi) === false){

                document.getElementById('sms_erro3').style.display = 'block';
            }else{

                document.getElementById('sms_erro3').style.display = 'none';
            }

            if(verificarTelefone(telefone)=== false){
                document.getElementById('sms_erro4').style.display = 'block';
            }else{
                document.getElementById('sms_erro4').style.display = 'none';
            }

            if(verificarBI(bi)===true && verificarTelefone(telefone)===true){
                document.getElementById('formulario_editar').submit();
            }
        }
    }

    document.getElementById('data_nascimento_e').addEventListener('input', function() {

if (this.value.split("-")[0] < 1000) {
    return;
}

const dataNascimento = new Date(this.value);
    const dataAtual = new Date();

    // Calcular limites de idade
    const dataMinima = new Date();
    dataMinima.setFullYear(dataAtual.getFullYear() - 70); // 70 anos atrás

    const dataMaxima = new Date();
    dataMaxima.setFullYear(dataAtual.getFullYear() - 17); // 17 anos atrás

    const mensagemErro = document.getElementById('data_nascimento_e_erro');

    // Verifica se a data é válida
    if (isNaN(dataNascimento.getTime())) {
        mensagemErro.textContent = 'Data inválida. Por favor, insira uma data válida.';
        mensagemErro.style.display = 'block';
        this.value = '';
        return;
    }

    if (dataNascimento < dataMinima) {
        mensagemErro.textContent = 'A idade máxima permitida é de 70 anos.';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else if (dataNascimento > dataMaxima) {
        mensagemErro.textContent = 'A idade mínima permitida é de 30 anos.';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else {
        mensagemErro.style.display = 'none';
    }
});


document.getElementById('data_admissao_e').addEventListener('change', function() {
const dataNascimentoInput = document.getElementById('data_nascimento').value;
const dataAdmissaoInput = this.value;
const mensagemErro = document.getElementById('data_admissao_e_erro');
if (this.value.split("-")[0] < 1000) {
    return;
}


// Se a data de nascimento não foi preenchida, não faz nada
if (!dataNascimentoInput) {
    mensagemErro.textContent = 'Por favor, preencha a data de nascimento primeiro.';
    mensagemErro.style.display = 'block';
    this.value = ''; // Limpa a data de admissão
    return;
}

const dataNascimento = new Date(dataNascimentoInput);
const dataAdmissao = new Date(dataAdmissaoInput);
const dataAtual = new Date();
// Calcula a data mínima para admissão (17 anos depois da data de nascimento)
const dataMinimaAdmissao = new Date(dataNascimento);
dataMinimaAdmissao.setFullYear(dataNascimento.getFullYear() + 17);

if (dataAdmissao < dataMinimaAdmissao) {
    mensagemErro.textContent = 'A data de admissão deve ser ao menos 17 anos após a data de nascimento.';
    mensagemErro.style.display = 'block';
    this.value = ''; // Limpa a data inválida
}else if (dataAdmissao > dataAtual) {
    mensagemErro.textContent = 'A data de admissão inválida.';
    mensagemErro.style.display = 'block';
    this.value = '';
} else {
    mensagemErro.style.display = 'none';
}
});

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('Dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ferdinando Roque\Documents\GitHub\creche\resources\views/Dashboard/pagina/listagem_motorista.blade.php ENDPATH**/ ?>