<?php $__env->startSection('conteudo'); ?>


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Rotas Funcionários</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Rotas Funcionários</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            <?php if($errors->any()): ?>

                    <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                        <span class="badge badge-pill badge-danger">Erro</span>
                        <ul class="errors">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li> <?php echo e($erro); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
            <?php endif; ?>

            <?php if(session()->has('sms')): ?>
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    <?php echo e(session()->get('sms')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>
            <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Preencha o campo obrigatório.

            </div>
            <div class="card">
                <div class="card-body">
                    <h5>Nova Associação</h5>

                    <hr>

                    <form id="formulario" action="<?php echo e(route('registar.rota.func')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="form-row">

                            <div class="form-group col-md-12">
                                <label for="inputCity">Buscar Motorista <span style="color: red">*</span></label>
                                <select id="func" name="func" class="form-control">
                                    <option value="" >seleccione o motorista</option>
                                    <?php $__currentLoopData = $funcionario; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $func): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($func->id_func); ?>"><?php echo e($func->nome_completo); ?> /
                                            <?php if($func->genero == "M"): ?>
                                                Masculino
                                            <?php else: ?>
                                                Feminino
                                            <?php endif; ?>
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="text" id="id_rota" name="id_rota" hidden value="<?php echo e($id); ?>" >
                            </div>

                        </div>


                        <button onclick="verificarRegisto()" class="btn  btn-primary float-right">Registar</button>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5>Listagem dos Motoristas Associados à rota</h5>
               </div>


                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Funcionário</th>
                                    <th>Gênero</th>
                                    <th>Função</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $rota_func; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td><?php echo e($rota->nome_completo); ?> </td>
                                        <td><?php echo e($rota->genero); ?></td>
                                        <td><?php echo e($rota->funcao); ?></td>


                                        <td>




                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('desassociar_motorista_a_rota')): ?>
                                                <a href="" onclick="retornaid_nome(<?php echo e($rota->id_associacao); ?>)"  data-toggle="modal" data-target="#Eliminar_director">
                                                    <i class="fa-solid fa-trash" style="color: red;"></i>
                                                </a>

                                            <?php endif; ?>



                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>



<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Associação</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar esta Associação ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="<?php echo e(route('eliminar.rota.func')); ?>" method="post" enctype="multipart/form-data" >
                    <?php echo csrf_field(); ?>
                    <input type="text" id="id_rota2" name="id_rota2" hidden>
                    <input type="text" name="id_rota_inicial" id="id_rota_inicial", hidden value="<?php echo e($id); ?>">
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<script>
    document.getElementById('sms_erro').style.display = 'none';
    function editar_rota(id, origem,destino){

        document.getElementById("id_rota").value = id;
        document.getElementById("origem").value = origem;
        document.getElementById("destino").value  = destino;
    }

    function buscar_data(){

        var data = document.getElementById('ano_letivo').value;

        const ano =  parseInt(data.split('-')[0], 10);
        var ano_letivo = ano+1;
        document.getElementById('ano_letivo2').value = ano_letivo;

    }


    function adicionar_professor(id) {
        document.getElementById('sms_erro').style.display = 'none';
        document.getElementById('id_turma').value = id;
    }

    function retornaid_nome(id){
        $('#id_rota2').val(id);
    }


    function verificarRegisto(){
        event.preventDefault();
        var func = document.getElementById("func").value;

        if(func ==="" ){
            document.getElementById('sms_erro').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';
            document.getElementById('formulario').submit();
        }
    }

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('Dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ferdinando Roque\Documents\GitHub\creche\resources\views/Dashboard/pagina/listagem_rotas_funcionario.blade.php ENDPATH**/ ?>