<?php $__env->startSection('conteudo'); ?>


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Salas</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Salas</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            <?php if($errors->any()): ?>
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li> <?php echo e($erro); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        <?php endif; ?>

            <?php if(session()->has('sms')): ?>
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    <?php echo e(session()->get('sms')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Ordem da Sala</th>
                                    <th>Capacidade máxima da Sala</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $salas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sala): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td>Sala nº <?php echo e($sala->id); ?> </td>
                                        <td><?php echo e($sala->capacidade); ?> Crianças</td>


                                        <td>


                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar_funcionario')): ?>
                                                <a href="" data-toggle="modal" data-target="#editar_director"

                                                onclick="editar_sala(<?php echo e(json_encode($sala->id)); ?>,<?php echo e(json_encode($sala->capacidade)); ?>)"
                                                >
                                                    <i class="fa-solid fa-pen-to-square" style="color: blue;"></i>
                                                </a>
                                            <?php endif; ?>



                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- [ Main Content ] end -->
</div>







<!-- editar director -->

<div id="editar_director" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Actualizar Capacidade da Sala</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">

                <div class="modal-body">
                    <form id="formulario_editar" action="<?php echo e(route('editar.sala')); ?>" method="post" enctype="multipart/form-data" >
                       <?php echo csrf_field(); ?>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Ordem da Sala:</label>
                                    <input type="text" id="id_ordem" name="id_ordem" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Capacidade:</label>
                                    <input type="text" id="capacidade" name="capacidade" class="form-control" >
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>



<script>

    function editar_sala(id, capacidade){

        document.getElementById("id_ordem").value = id;
        document.getElementById("capacidade").value = capacidade;

    }






</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('Dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ferdinando Roque\Documents\GitHub\creche\resources\views/Dashboard/pagina/listagem_salas.blade.php ENDPATH**/ ?>