@extends('Dashboard.layout')
@section('conteudo')

<div class="pcoded-content">

    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Pagamento</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Pagamento</a></li>
                        <li class="breadcrumb-item"><a href="#!">Novo</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-sm-12"  >
            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif
            <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Preencha todos os campos obrigatórios.

            </div>




            <div class="card">
                <div class="card-body">
                    <h5>Novo</h5>
                    <hr>
                    <form id="formulario" action="{{route('pagar')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <h6 style="color: black">Informaçoes Pessoais</h6>

                        <div class="form-row">

                            <div class="form-group col-md-6">
                                <label for="inputCity">Criança <span style="color: red">*</span> </label>
                                <select id="crianca" name="crianca" class="form-control">
                                    <option value="" >seleccione a criança</option>
                                    @foreach ($crianca as $cria)
                                        <option value="{{$cria->id}}">{{$cria->nome_completo}}
                                        </option>
                                    @endforeach
                                </select>

                            </div>

                            <div class="form-group col-md-6">
                                <label for="inputZip">Ano Lectivo <span style="color: red">*</span></label>
                                <select id="ano_letivo" name="ano_letivo" class="form-control">
                                    <option value="" >seleccione o ano lectivo</option>
                                    @foreach ($ano_letivo as $ano)
                                        <option value="{{$ano->id}}" data-inicio="{{ $ano->inicio }}" data-fim="{{ $ano->fim }}"  >{{$ano->inicio}} à {{$ano->fim}}</option>
                                    @endforeach
                                </select>
                                <small id="data_nascimento_erro" style="color: red; display: none;"></small>

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputZip">Mês  <span style="color: red">*</span></label>
                                <input readonly  type="month" id="mes" name="mes" class="form-control" value="CI-" maxlength="13" required>
                                <small id="cedula-error" style="color: red; display: none;">Formato inválido! O formato deve ser 'CI-XXXXXXX/XX'.</small>

                            </div>
                            <div class="form-group col-md-4">
                                <label for="valor_pago">Valor Pago <span style="color: red">*</span></label>
                                <input type="text" id="valor_pago" name="valor_pago" class="form-control" required>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="inputZip">Comprovativo </label>
                                <input type="file" id="comprovativo" name="comprovativo" class="form-control" value="CI-" maxlength="13" required>
                                <small id="cedula-error" style="color: red; display: none;">Formato inválido! O formato deve ser 'CI-XXXXXXX/XX'.</small>

                            </div>
                        </div>

                        <button onclick="verificarRegisto()" class="btn  btn-primary float-right">Comfirmar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <input type="text" id="crianca_reg"  hidden value="{{$crianca}}" >

</div>



<script>
    document.getElementById('sms_erro').style.display = 'none';

    function verificarRegisto(){
        event.preventDefault();

        var crianca = document.getElementById('crianca').value;
        var ano_letivo = document.getElementById('ano_letivo').value;
        var mes = document.getElementById('mes').value;
        var valor_pago = document.getElementById('valor_pago').value;


        if(crianca ==='' || ano_letivo ==='' || mes ==='' || valor_pago ===''){
            document.getElementById('sms_erro').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';
            document.getElementById('formulario').submit();

        }
    }


    document.getElementById('ano_letivo').addEventListener('change', function() {

        const inicio = this.options[this.selectedIndex].getAttribute('data-inicio');
        const fim = this.options[this.selectedIndex].getAttribute('data-fim');
        const mesInput = document.getElementById('mes');


        if (inicio && fim) {
            mesInput.readOnly = false;
            // Converter 'dia/mês/ano' para 'ano-mês-dia'
            const [diaInicio, mesInicio, anoInicio] = inicio.split('/');
            const [diaFim, mesFim, anoFim] = fim.split('/');

            const dataInicio = new Date(`${anoInicio}-${mesInicio}-${diaInicio}`);
            const dataFim = new Date(`${anoFim}-${mesFim}-${diaFim}`);

            // Define limites para o input "month"
            mesInput.min = `${dataInicio.getFullYear()}-${String(dataInicio.getMonth() + 1).padStart(2, '0')}`;
            mesInput.max = `${dataFim.getFullYear()}-${String(dataFim.getMonth() + 1).padStart(2, '0')}`;
            mesInput.value = mesInput.min; // Define valor inicial no primeiro mês do ano letivo
            const oy = `${dataInicio.getFullYear()}-${String(dataInicio.getMonth() + 1).padStart(2, '0')}`;


        } else {
            mesInput.readOnly = true;
            mesInput.min = "";
            mesInput.max = "";
            mesInput.value = "";
        }
    });


    document.addEventListener('DOMContentLoaded', function() {
    const valorPago = document.getElementById('valor_pago');

    valorPago.addEventListener('input', function() {
        // Remove tudo que não for dígito
        let value = valorPago.value.replace(/\D/g, '');

        // Converte para número e limita a 1.000.000
        if (Number(value) > 100000000) { // Considera os centavos, por isso 1000000 * 100
            value = value.slice(0, -1);
        }

        // Formata como moeda (dividindo por 100 para considerar centavos)
        valorPago.value = (Number(value) / 100).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    });
});



</script>


@endsection
