@extends('Dashboard.layout')
@section('conteudo')

<div class="pcoded-content">

    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Transportes</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Transportes</a></li>
                        <li class="breadcrumb-item"><a href="#!">Nova</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-sm-12"  >
            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif
            <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Preencha todos os campos obrigatórios.

            </div>


            <div class="card">
                <div class="card-body">
                    <h5>Novo</h5>

                    <hr>
                    <form id="formulario" action="{{route('registar.trasnporte.post')}}" method="post" enctype="multipart/form-data">
                        @csrf

                        <div class="form-row">

                            <div class="form-group col-md-6">
                                <label for="inputCity">Marca <span style="color: red">*</span></label>
                                <input type="text" id="marca" name="marca" class="form-control" >

                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputCity">Modelo <span style="color: red">*</span></label>
                                <input type="text"  id="modelo" name="modelo" class="form-control" >

                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="inputZip">Matrícula <span style="color: red">*</span></label>
                                <input    type="text" id="matricula" name="matricula" class="form-control" >
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputZip">Cor <span style="color: red">*</span></label>
                                <input  id="cor" name="cor" class="form-control" >
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputZip">Capacidade <span style="color: red">*</span></label>
                                <input type="number" min="1" id="capacidade" name="capacidade" class="form-control" >
                            </div>

                        </div>

                        <button onclick="verificarRegisto()" class="btn  btn-primary float-right">Registar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<script>

    document.getElementById('sms_erro').style.display = 'none';

function verificarRegisto(){
    event.preventDefault();
    var marca = document.getElementById('marca').value;
    var modelo = document.getElementById('modelo').value;
    var matricula = document.getElementById('matricula').value;
    var cor = document.getElementById('cor').value;
    var capacidade =  document.getElementById('capacidade').value;


    if(capacidade == 0 || marca ==="" || modelo==="" || cor === "" || matricula ===""){
        document.getElementById('sms_erro').style.display = 'block';
    }else{
        document.getElementById('sms_erro').style.display = 'none';
        document.getElementById('formulario').submit();
    }
}


</script>


@endsection
