@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Turmas Crianças</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Turmas Crianças</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            @if($errors->any())

                    <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                        <span class="badge badge-pill badge-danger">Erro</span>
                        <ul class="errors">
                            @foreach($errors->all() as $erro)
                                <li> {{ $erro }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
            @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif
            <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Preencha o campo obrigatório.

            </div>



            <div class="card">
                <div class="card-header">
                    <h5>Listagem das Crianças da Turma: {{$turma->nome}}</h5>
               </div>


                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Nome da Turma</th>
                                    <th>Cédula</th>
                                    <th>Data de Nascimento</th>
                                    <th>Gênero</th>
                                    <th>Responsável</th>
                                    <th>Contacto</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($turma_crianca as $tur)

                                    <tr>
                                        <td>{{$tur->nome_completo}} </td>
                                        <td>{{$tur->bi_cedula}}</td>
                                        <td>{{$tur->data_nascimento}}</td>
                                        <td>
                                            @if ( $tur->genero== "M" )
                                                Masculino
                                            @else
                                                Feminino
                                            @endif

                                        </td>
                                        <td>{{$tur->responsavel1}}</td>
                                        <td>{{$tur->contacto}}</td>
                                        <td>
                                            @can('ver_detalhes_crianca')
                                                @if ($tur->id !=null)
                                                <a href="{{route('perfil.crianca',['id'=>$tur->id])}}"
                                                    >
                                                         <i class="fa-solid fa-eye" style="color: blue;"></i>
                                                     </a>
                                                @endif

                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>



<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Associação</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar esta Associação ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="{{route('eliminar.rota.func')}}" method="post" enctype="multipart/form-data" >
                    @csrf
                    <input type="text" id="id_rota2" name="id_rota2" hidden>
                    <input type="text" name="id_rota_inicial" id="id_rota_inicial", hidden value="{{}}">
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<script>
    document.getElementById('sms_erro').style.display = 'none';
    function editar_rota(id, origem,destino){

        document.getElementById("id_rota").value = id;
        document.getElementById("origem").value = origem;
        document.getElementById("destino").value  = destino;
    }

    function buscar_data(){

        var data = document.getElementById('ano_letivo').value;

        const ano =  parseInt(data.split('-')[0], 10);
        var ano_letivo = ano+1;
        document.getElementById('ano_letivo2').value = ano_letivo;

    }


    function adicionar_professor(id) {
        document.getElementById('sms_erro').style.display = 'none';
        document.getElementById('id_turma').value = id;
    }

    function retornaid_nome(id){
        $('#id_rota2').val(id);
    }


    function verificarRegisto(){
        event.preventDefault();
        var func = document.getElementById("func").value;

        if(func ==="" ){
            document.getElementById('sms_erro').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';
            document.getElementById('formulario').submit();
        }
    }

</script>


@endsection
