<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('turma_criancas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_turma')->nullable() ;
            $table->foreign('id_turma')->references('id')->on('turmas')->onDelete('CASCADE');

            $table->unsignedBigInteger('id_crianca')->nullable() ;
            $table->foreign('id_crianca')->references('id')->on('criancas')->onDelete('CASCADE');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('turma_criancas');
    }
};
