<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transporte;
use App\Models\Rota;
use App\Models\Rota_funcionario;
use Illuminate\Support\Facades\DB;
use Exception;

class TransporteController extends Controller
{
    public function novo_transporte(){
        return view('Dashboard.pagina.novo_transporte');
    }

    public function listar_transporte(){
        $transporte = Transporte::all();
        return view('Dashboard.pagina.listagem_transporte',['transporte' => $transporte ]);
    }

    public function post_transporte(Request $request){
        try {
            DB::beginTransaction();

            $trans= new Transporte();
            $trans->marca = $request->marca;
            $trans->modelo =$request->modelo;
            $trans->matricula = $request->matricula;
            $trans->cor =$request->cor;
            $trans->capacidade = $request->capacidade;
            $trans->save();

            DB::commit();
            return redirect()->route('transporte.listar')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function eliminar_transporte(Request $request){
        try {
            DB::beginTransaction();
            Transporte::find($request->id_trasporte)->delete();
            DB::commit();
            return redirect()->route('transporte.listar')->with('sms', 'Transporte eliminado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function editar_trasnporte(Request $request){

        try{
            DB::beginTransaction();

            $trans = Transporte::findOrFail($request->id);
            $trans->marca = $request->marca;
            $trans->modelo =$request->modelo;
            $trans->matricula = $request->matricula;
            $trans->cor =$request->cor;
            $trans->capacidade = $request->capacidade;
            $trans->save();

            DB::commit();
            return redirect()->route('transporte.listar')->with('sms', 'Actualização efetuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }


    public function nova_rota(){
        return view('Dashboard.pagina.nova_rota');
    }

    public function listar_rota(){

        $rota = Rota::all();
        return view('Dashboard.pagina.listagem_rotas',['rota' => $rota ]);

    }

    public function post_rota(Request $request){

        try {
            DB::beginTransaction();

            $rota= new Rota();
            $rota->origem = $request->origem;
            $rota->destino =$request->destino;
            $rota->save();

            DB::commit();
            return redirect()->route('rota.listar')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function eliminar_rota(Request $request){
        try {
            DB::beginTransaction();
            Rota::find($request->id_rota)->delete();
            DB::commit();
            return redirect()->route('rota.listar')->with('sms', 'Rota eliminada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function editar_rota(Request $request){

        try{
            DB::beginTransaction();

            $rota = Rota::findOrFail($request->id_rota);
            $rota->origem = $request->origem;
            $rota->destino =$request->destino;
            $rota->save();

            DB::commit();
            return redirect()->route('rota.listar')->with('sms', 'Actualização efetuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function rota_funcionario($id){

        $funcionario = DB::table('pessoas as P')
            ->select('P.nome_completo', 'P.genero','F.funcao', 'F.id as id_func')
            ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
            ->where('F.funcao','=','Motorista')
            ->get();


        $rota_func = DB::table('pessoas as P')
            ->select('P.nome_completo','P.genero', 'RF.id as id_associacao',
            'F.funcao')
            ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
            ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
            ->leftjoin('rota_funcionarios as RF', 'RF.id_funcionario', '=', 'F.id')
            ->leftjoin('rotas as R', 'R.id', '=', 'RF.id_rota')
            ->where('F.funcao','=','Motorista')
            ->where('R.id', '=', $id)
            ->get();

        return view('Dashboard.pagina.listagem_rotas_funcionario',['id'=>$id, 'rota_func' => $rota_func, 'funcionario' =>$funcionario ]);
    }

    public function associar_rota_func(Request $request){

        try {
            DB::beginTransaction();

            $rota= new Rota_funcionario();
            $rota->id_funcionario = $request->func;
            $rota->id_rota = $request->id_rota;
            $rota->save();

            DB::commit();
            return redirect()->route('rotas.funcionario',[$request->id_rota])->with('sms', 'Associação efetuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function desassociar_rota_func(Request $request){
        try {
            DB::beginTransaction();
            Rota_funcionario::find($request->id_rota2)->delete();
            DB::commit();
            return redirect()->route('rotas.funcionario',$request->id_rota_inicial)->with('sms', 'Rota eliminada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }


}
