<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Pessoa;
use App\Models\Funcionario;
use App\Models\User;
use App\Models\Contacto;
use App\Models\Director;
use App\Models\Secretaria;
use App\Models\RoleUser;

class FuncionarioController extends Controller
{
    public function registar(){

        $funcionario = DB::table('pessoas as P')
        ->select('P.bi_cedula','U.email')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('users as U', 'F.id', '=', 'U.id_funcionario')
        ->get();

        return view('Dashboard.pagina.registar_funcionario',['funcionario'=>$funcionario ]);
    }

    public function registar_director(){
        $funcionario = DB::table('pessoas as P')
        ->select('P.bi_cedula','U.email')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('users as U', 'F.id', '=', 'U.id_funcionario')
        ->get();
        return view('Dashboard.pagina.registar_director',['funcionario' => $funcionario ]);
    }

    public function registar_post(Request $request){

        try {
            //$imagemPath = $request->file('foto') ? $request->file('foto')->store('imagens_funcionario') : null;         php artisan storage:link
            //$imagemPath = $request->file('foto')? $request->file('foto')->store('public/imagens_funcionario'): null;

            $nomeImage = "";
            if ($request->hasFile('foto') && $request->file('foto')->isValid()) {
                $path = $request->file('foto')->store('imagem_funcionario', 'public');
                $nomeImage = basename($path); // Obtém apenas o nome do arquivo
            } else {
                $nomeImage = null;
            }



            DB::beginTransaction();
            $pessoa = new Pessoa();

            $pessoa->nome_completo = $request->nome;
            $pessoa->bi_cedula = $request->bi;
            $pessoa->data_nascimento = $request->data_nascimento;
            $pessoa->genero = $request->genero;
            $pessoa->foto = $nomeImage;
            $pessoa->save();

            $funcionario = new Funcionario();
            $funcionario->data_admissao = $request->data_admissao;
            $funcionario->funcao = $request->funcao;
            $funcionario->id_pessoa = $pessoa->id;
            $funcionario->save();

            $contacto = new Contacto();
            $contacto->telefone =  $request->telefone ;
            $contacto->cidade =  $request->cidade ;
            $contacto->endereco =  $request->endereco ;
            $contacto->id_funcionario = $funcionario->id;
            $contacto->save();

            if($request->funcao == "Secretaria"){
                $user = new User();
                $user->name = $request->nome_utilizador ;
                $user->email = $request->email ;
                $user->password = Hash::make($request->palavra_passe);
                $user->papel = 'Secretaria';
                $user->id_funcionario = $funcionario->id;
                $user->save();

                $secr = new Secretaria();
                $secr->id_user = $user->id;
                $secr->save();

                RoleUser::create([
                    'model_id' => $user->id,
                    'role_id' => 3,
                    'model_type' => 'App\Models\User',
                ]);
            }

            DB::commit();
            return redirect()->route('listar.funcionario')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {

            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function listar(){
        $funcionario = DB::table('pessoas as P')
        ->select('P.id','P.foto','P.nome_completo', 'P.bi_cedula', 'P.data_nascimento','P.genero',
        'F.data_admissao', 'F.funcao',
        'C.telefone','C.cidade', 'C.endereco')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
        ->where('F.funcao','!=','Director')
        ->Where('F.funcao','!=','Administrador')
        ->get();

        return view('Dashboard.pagina.listagem_funcionario',['funcionario' => $funcionario ]);

    }
    public function listar_professor(){
        $funcionario = DB::table('pessoas as P')
        ->select('P.id','P.foto','P.nome_completo', 'P.bi_cedula', 'P.data_nascimento','P.genero',
        'F.data_admissao', 'F.funcao',
        'C.telefone','C.cidade', 'C.endereco')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
        ->where('F.funcao','=','Vigilante')
        ->get();

        return view('Dashboard.pagina.listagem_professor',['funcionario' => $funcionario ]);

    }

    public function listar_secretario(){
        $funcionario = DB::table('pessoas as P')
        ->select('P.id','P.foto','P.nome_completo', 'P.bi_cedula', 'P.data_nascimento','P.genero',
        'F.data_admissao', 'F.funcao',
        'C.telefone','C.cidade', 'C.endereco')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
        ->where('F.funcao','=','Secretaria')
        ->get();

        return view('Dashboard.pagina.listagem_secretaria',['funcionario' => $funcionario ]);

    }

    public function listar_motorista(){
        $funcionario = DB::table('pessoas as P')
        ->select('P.id','P.foto','P.nome_completo', 'P.bi_cedula', 'P.data_nascimento','P.genero',
        'F.data_admissao', 'F.funcao',
        'C.telefone','C.cidade', 'C.endereco')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
        ->where('F.funcao','=','Motorista')
        ->get();

        return view('Dashboard.pagina.listagem_motorista',['funcionario' => $funcionario ]);

    }


    public function registar_director_store(Request $request){

        try {

            $nomeImage = "";
            if ($request->hasFile('foto') && $request->file('foto')->isValid()) {
                $path = $request->file('foto')->store('imagem_funcionario', 'public');
                $nomeImage = basename($path); // Obtém apenas o nome do arquivo
            } else {
                $nomeImage = null;
            }

            DB::beginTransaction();
           //Desabilita o novo
            $this->desativar_director_actual($this->buscar_director_actual());

            $pessoa = new Pessoa();

            $pessoa->nome_completo = $request->nome;
            $pessoa->bi_cedula = $request->bi;
            $pessoa->data_nascimento = $request->data_nascimento;
            $pessoa->genero = $request->genero;
            $pessoa->foto = $nomeImage;
            $pessoa->save();

            $funcionario = new Funcionario();
            $funcionario->data_admissao = $request->data_admissao;
            $funcionario->funcao = "Director";
            $funcionario->id_pessoa = $pessoa->id;
            $funcionario->save();

            $contacto = new Contacto();
            $contacto->telefone =  $request->telefone ;
            $contacto->cidade =  $request->cidade ;
            $contacto->endereco =  $request->endereco ;
            $contacto->id_funcionario = $funcionario->id;
            $contacto->save();


            $user = new User();
            $user->name = $request->nome_utilizador ;
            $user->email = $request->email ;
            $user->password = Hash::make($request->palavra_passe);
            $user->papel = 'Director';
            $user->id_funcionario = $funcionario->id;
            $user->save();

            $director = new Director();
            $director->estado = "Actual";
            $director->id_user =  $user->id;
            $director->save();

            RoleUser::create([
                'model_id' => $user->id,
                'role_id' => 2,
                'model_type' => 'App\Models\User',
            ]);


            DB::commit();
            return redirect()->route('listar.director')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {

            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function listar_director(){

        $funcionario = DB::table('pessoas as P')
        ->select('P.id','P.foto','P.nome_completo', 'P.bi_cedula', 'P.data_nascimento','P.genero',
        'F.data_admissao', 'F.funcao', 'P.data_nascimento', 'F.data_admissao',
        'C.telefone','C.cidade', 'C.endereco', 'D.estado', 'U.email','U.name')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
        ->leftjoin('users as U', 'F.id', '=', 'U.id_funcionario')
        ->leftjoin('directors as D', 'U.id', '=', 'D.id_user')
        ->where('U.papel','=','Director')
        ->orderby('P.id','Desc')
        ->get();

        return view('Dashboard.pagina.listagem_director',['funcionario' => $funcionario ]);
    }

    public function desativar_director_actual($director){

        if($director != null){
            $director->estado = 'Anterior';
            $director->save();

            $this->desativar_user($this->buscar_user_by_id($director));
        }

    }

    public function buscar_director_actual(){
        return Director::where('estado','=','Actual')->first();
    }

    public function buscar_user_by_id($director){

        if($director != null){
            return User::where('id','=',$director->id_user)->first();
        }
    }

    public function desativar_user($user){

        if($user != null){
            $user->estado = 'Desactivado';
            $user->save();
        }

    }

    public function eliminar_director(Request $request){

        $pessoa = $this->buscar_pessoa($request->id_director);

       try {
            DB::beginTransaction();

            //eliminar contacto
            Contacto::find($pessoa->contacto)->delete();
            //eliminar permissao
            RoleUser::where('model_id', '=', $pessoa->user_role)->delete();
            //eliminar director
            Director::find($pessoa->director)->delete();
            //eliminar user
            User::find($pessoa->user)->delete();
            //eliminar funcionario
            Funcionario::find($pessoa->funcionario)->delete();
            //eliminar pessoa
            Pessoa::find($pessoa->pessoa)->delete();

            DB::commit();
            return redirect()->route('listar.director')->with('sms', 'Registo eliminado com sucesso');
        } catch (\Throwable $th) {

            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }


    public function eliminar_funcionario(Request $request){

        $pessoa = $this->buscar_pessoa($request->id_director);

       try {
            DB::beginTransaction();

            //eliminar contacto
            Contacto::find($pessoa->contacto)->delete();

            if($pessoa->funcao =="Secretaria"){
                //eliminar permissao
                RoleUser::where('model_id', '=', $pessoa->user_role)->delete();
                //eliminar director
                Secretaria::find($pessoa->secretaria)->delete();
                //eliminar user
                User::find($pessoa->user)->delete();
            }
            //eliminar funcionario
            Funcionario::find($pessoa->funcionario)->delete();
            //eliminar pessoa
            Pessoa::find($pessoa->pessoa)->delete();

            DB::commit();
            return redirect()->route('listar.funcionario')->with('sms', 'Registo eliminado com sucesso');
        } catch (\Throwable $th) {

            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function buscar_pessoa($id_pessoa){
        return DB::table('pessoas as P')
        ->select('P.id as pessoa', 'F.funcao', 'S.id as secretaria'  , 'F.id as funcionario', 'C.id as contacto', 'U.id as user','D.id as director','R.model_id as user_role')
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->leftjoin('contactos as C', 'F.id', '=', 'C.id_funcionario')
        ->leftjoin('users as U', 'F.id', '=', 'U.id_funcionario')
        ->leftjoin('directors as D', 'U.id', '=', 'D.id_user')
        ->leftjoin('secretarias as S', 'U.id', '=', 'S.id_user')
        ->leftjoin('model_has_roles as R', 'U.id','=','R.model_id')
        ->where('P.id','=',$id_pessoa)
        ->first();
    }

   public function editar_director(Request $request){

        $pessoa = $this->buscar_pessoa($request->id_editar);

        try {
            DB::beginTransaction();

            $pessoa2 = Pessoa::findOrFail($pessoa->pessoa);
            if($request->nome_e != null){
                $pessoa2->nome_completo = $request->nome_e;
            }
            if($request->bi_e != null){
                $pessoa2->bi_cedula = $request->bi_e;
            }
            if($request->genero_e != null){
                $pessoa2->genero = $request->genero_e;
            }
            if($request->data_nascimento_e != null){
                $pessoa2->data_nascimento = $request->data_nascimento_e;
            }
            $pessoa2->save();

            $funcionario = Funcionario::findOrFail($pessoa->funcionario);
            if($request->data_admissao_e != null){
                $funcionario->data_admissao = $request->data_admissao_e;
                $funcionario->save();
            }


            $contacto = Contacto::findOrFail($pessoa->contacto);
            if($request->telefone_e != null){
                $contacto->telefone = $request->telefone_e;
            }
            if($request->cidade_e != null){
                $contacto->cidade = $request->cidade_e;
            }
            if($request->endereco_e != null){
                $contacto->endereco = $request->endereco_e;
            }
            $contacto->save();

            DB::commit();
            return redirect()->route('listar.director')->with('sms', 'Registo actualizado com sucesso');
        } catch (\Throwable $th) {

            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }

   }

   public function editar_funcionario(Request $request){

        $pessoa = $this->buscar_pessoa($request->id_editar);

        try {
            DB::beginTransaction();

            $pessoa2 = Pessoa::findOrFail($pessoa->pessoa);
            if($request->nome_e != null){
                $pessoa2->nome_completo = $request->nome_e;
            }
            if($request->bi_e != null){
                $pessoa2->bi_cedula = $request->bi_e;
            }
            if($request->genero_e != null){
                $pessoa2->genero = $request->genero_e;
            }
            if($request->data_nascimento_e != null){
                $pessoa2->data_nascimento = $request->data_nascimento_e;
            }
            $pessoa2->save();

            $funcionario = Funcionario::findOrFail($pessoa->funcionario);
            if($request->data_admissao_e != null){
                $funcionario->data_admissao = $request->data_admissao_e;
            }
            $funcionario->funcao = $request->funcao_e;
            $funcionario->save();

            $contacto = Contacto::findOrFail($pessoa->contacto);
            if($request->telefone_e != null){
                $contacto->telefone = $request->telefone_e;
            }
            if($request->cidade_e != null){
                $contacto->cidade = $request->cidade_e;
            }
            if($request->endereco_e != null){
                $contacto->endereco = $request->endereco_e;
            }
            $contacto->save();

            if($request->funcao == "Secretaria"){

                $user = new User();
                $user->name = $request->nome_utilizador ;
                $user->email = $request->email ;
                $user->password = Hash::make($request->palavra_passe);
                $user->papel = 'Secretaria';
                $user->id_funcionario = $pessoa->funcionario;
                $user->save();

                $secr = new Secretaria();
                $secr->id_user = $user->id;
                $secr->save();

                RoleUser::create([
                    'model_id' => $user->id,
                    'role_id' => 3,
                    'model_type' => 'App\Models\User',
                ]);

            }

            DB::commit();
            return redirect()->route('listar.funcionario')->with('sms', 'Registo actualizado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }

    }

}
